package io.bitsensor.plugins.java.http.configuration;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.proto.shaded.com.google.gson.Gson;
import io.bitsensor.proto.shaded.com.google.gson.JsonElement;
import io.bitsensor.proto.shaded.com.google.gson.JsonObject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
public class HttpMessageConverterReadInterceptor implements MethodInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(HttpMessageConverterReadInterceptor.class);
    private Gson gson = new Gson();

    private static void flatten(JsonElement object, String prefix, JsonObject parent) {
        if (object.isJsonObject()) {
            if (object.getAsJsonObject().entrySet().size() == 0) {
                if (!prefix.equals(""))
                    parent.add(prefix, object);
            }
            for (Map.Entry<String, JsonElement> entry : object.getAsJsonObject().entrySet()) {
                flatten(entry.getValue(), (prefix.isEmpty() ? "" : prefix + ".") + entry.getKey(), parent);
            }
        } else {
            parent.add(prefix, object);
        }
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object proceed = invocation.proceed();

        JsonObject out = new JsonObject();
        flatten(gson.toJsonTree(proceed), "", out);

        BitSensor.apply(datapointBuilder -> {
            for (Map.Entry<String, JsonElement> jsonElementByKey : out.entrySet()) {
                String key = jsonElementByKey.getKey();
                JsonElement value = jsonElementByKey.getValue();

                if (value.isJsonPrimitive()) {
                    String primitiveValue = value.getAsString();
                    BitSensor.addInput(key, primitiveValue);
                }
            }
        });

        return proceed;
    }
}
