package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.plugins.java.core.BitSensor;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * Collects information about the HTTP request data.
 * <p>
 * Only GET parameters can be collected successfully, the body has to be added manually since it can only be read once
 * due to limitations of {@link HttpServletRequest}.
 * </p>
 */
@Component
public class HttpInputHandler implements RequestHandler {

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {
        String method = request.getMethod().toLowerCase();
        request.getParameterMap().forEach((key, values) -> {
            String valueString = "";
            if (values.length > 1) {
                valueString = Arrays.toString(values);
            } else if (values.length == 1) {
                valueString = values[0];
            }
            BitSensor.addInput("http." + method + "." + key, valueString);
        });

        String sessionId = request.getRequestedSessionId();
        if (sessionId != null) {
            BitSensor.addContext("session.sessionId", sessionId);
        }
    }

    @Override
    public ExecutionMoment getExecutionMoment() {
        return ExecutionMoment.PRE_HANDLE;
    }

}
