/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.handler.Handler;
import io.bitsensor.plugins.java.http.filter.handler.RequestHandler;
import javax.inject.Named;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Named
public class HttpRequestHandler
implements RequestHandler {
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {
        if (request.getDispatcherType().equals((Object)DispatcherType.REQUEST)) {
            BitSensor.addContext((String)"http.version", (String)request.getProtocol());
            BitSensor.addContext((String)"http.query", (String)request.getQueryString());
            BitSensor.addContext((String)"http.userAgent", (String)request.getHeader("User-Agent"));
            BitSensor.addContext((String)"http.referer", (String)request.getHeader("Referer"));
            BitSensor.addContext((String)"http.type", (String)request.getMethod());
            BitSensor.addContext((String)"http.acceptMedia", (String)request.getHeader("Accept"));
            BitSensor.addContext((String)"http.acceptCharset", (String)request.getHeader("Accept-Charset"));
            BitSensor.addContext((String)"http.acceptEncoding", (String)request.getHeader("Accept-Encoding"));
            BitSensor.addContext((String)"http.acceptLanguage", (String)request.getHeader("Accept-Language"));
            BitSensor.addContext((String)"http.pathInfo", (String)request.getPathInfo());
            BitSensor.addContext((String)"http.https", (String)Boolean.toString(request.isSecure()));
            BitSensor.addContext((String)"authentication.type", (String)request.getAuthType());
            BitSensor.addContext((String)"authentication.user", (String)request.getRemoteUser());
            BitSensor.addEndpoint((String)"address", (String)request.getLocalAddr());
            BitSensor.addEndpoint((String)"name", (String)request.getHeader("Host"));
            BitSensor.addEndpoint((String)"software", (String)request.getServletContext().getServerInfo());
            BitSensor.addEndpoint((String)"port", (String)Integer.toString(request.getServerPort()));
            BitSensor.addEndpoint((String)"uri", (String)request.getRequestURI());
        } else if (request.getDispatcherType().equals((Object)DispatcherType.FORWARD)) {
            BitSensor.addEndpoint((String)"forward.uri", (String)request.getRequestURI());
        }
    }

    public Handler.ExecutionMoment getExecutionMoment() {
        return Handler.ExecutionMoment.PRE_HANDLE;
    }
}

