package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.plugins.java.core.BitSensor;

import javax.inject.Named;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Collects information that is only available after the request is handled by the application.
 */
@Named
public class HttpStatusHandler implements RequestHandler {

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {
        DispatcherType dispatcherType = request.getDispatcherType();
        String key = null;
        if (dispatcherType.equals(DispatcherType.REQUEST)) {
            key = "http.code";
        } else if (dispatcherType.equals(DispatcherType.FORWARD)) {
            key = "forward.code";
        }
        BitSensor.addEndpoint(key, Integer.toString(response.getStatus()));
    }

    /**
     * @return {@link ExecutionMoment#POST_HANDLE}
     */
    @Override
    public ExecutionMoment getExecutionMoment() {
        return ExecutionMoment.POST_HANDLE;
    }
}
