package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.plugins.java.core.BitSensor;

import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Collects information from ModSecurity.
 *
 * @see <a href="https://www.modsecurity.org/">www.modsecurity.org</a>
 */
@Named
public class ModSecurityHandler implements RequestHandler {

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {
        BitSensor.addContext("modSecurity.events", request.getHeader("X-Waf-Events"));
        BitSensor.addContext("modSecurity.score", request.getHeader("X-Waf-Score"));
    }

    /**
     * @return {@link ExecutionMoment#PRE_HANDLE}
     */
    @Override
    public ExecutionMoment getExecutionMoment() {
        return ExecutionMoment.PRE_HANDLE;
    }
}
