/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.http.configuration;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.proto.shaded.com.google.gson.Gson;
import io.bitsensor.proto.shaded.com.google.gson.JsonElement;
import io.bitsensor.proto.shaded.com.google.gson.JsonObject;
import java.util.Map;
import javax.inject.Named;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class HttpMessageConverterReadInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(HttpMessageConverterReadInterceptor.class);
    private Gson gson = new Gson();

    private static void flatten(JsonElement object, String prefix, JsonObject parent) {
        if (object.isJsonObject()) {
            if (object.getAsJsonObject().entrySet().size() == 0 && !prefix.equals("")) {
                parent.add(prefix, object);
            }
            for (Map.Entry entry : object.getAsJsonObject().entrySet()) {
                HttpMessageConverterReadInterceptor.flatten((JsonElement)entry.getValue(), (prefix.isEmpty() ? "" : prefix + ".") + (String)entry.getKey(), parent);
            }
        } else {
            parent.add(prefix, object);
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object proceed = invocation.proceed();
        JsonObject out = new JsonObject();
        HttpMessageConverterReadInterceptor.flatten(this.gson.toJsonTree(proceed), "", out);
        BitSensor.apply(datapointBuilder -> {
            for (Map.Entry jsonElementByKey : out.entrySet()) {
                String key = (String)jsonElementByKey.getKey();
                JsonElement value = (JsonElement)jsonElementByKey.getValue();
                if (!value.isJsonPrimitive()) continue;
                String primitiveValue = value.getAsString();
                BitSensor.addInput((String)key, (String)primitiveValue);
            }
        });
        return proceed;
    }
}

