package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.plugins.java.core.BitSensor;

import javax.inject.Named;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Handles cookies the client sent with this request
 *
 * @see <a href=https://www.ncsc.nl/actueel/whitepapers/ict-beveiligingsrichtlijnen-voor-webapplicaties.html>ICT-Beveiligingsrichtlijnen
 * voor Webapplicaties</a>
 */
@Named
public class CookieHandler implements RequestHandler {

    public static final String SECURE_ATTRIBUTE_NAME = "Secure";
    public static final String HTTP_ONLY_ATTRIBUTE_NAME = "HttpOnly";

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {

        if (request.getCookies() == null) {
            return;
        }

        for (Cookie cookie : request.getCookies()) {
            String cookieName = "cookie." + cookie.getName();
            BitSensor.addInput(cookieName, cookie.getValue());

            // checks compliance
            if (!cookie.getSecure()) {
                BitSensor.addNonCompliance(SECURE_ATTRIBUTE_NAME, cookieName);
            }
            if (!cookie.isHttpOnly()) {
                BitSensor.addNonCompliance(HTTP_ONLY_ATTRIBUTE_NAME, cookieName);
            }
        }
    }

    @Override
    public ExecutionMoment getExecutionMoment() {
        return ExecutionMoment.PRE_HANDLE;
    }
}
