/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.handler.Handler;
import io.bitsensor.plugins.java.http.filter.handler.RequestHandler;
import javax.inject.Named;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Named
public class CookieHandler
implements RequestHandler {
    public static final String SECURE_ATTRIBUTE_NAME = "Secure";
    public static final String HTTP_ONLY_ATTRIBUTE_NAME = "HttpOnly";

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {
        if (request.getCookies() == null) {
            return;
        }
        for (Cookie cookie : request.getCookies()) {
            String cookieName = "cookie." + cookie.getName();
            BitSensor.addInput((String)cookieName, (String)cookie.getValue());
            if (!cookie.getSecure()) {
                BitSensor.addNonCompliance((String)SECURE_ATTRIBUTE_NAME, (String)cookieName);
            }
            if (cookie.isHttpOnly()) continue;
            BitSensor.addNonCompliance((String)HTTP_ONLY_ATTRIBUTE_NAME, (String)cookieName);
        }
    }

    public Handler.ExecutionMoment getExecutionMoment() {
        return Handler.ExecutionMoment.PRE_HANDLE;
    }
}

