package io.bitsensor.plugins.java.http.filter.handler;

import io.bitsensor.plugins.java.core.BitSensor;

import javax.inject.Named;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Collects information about the HTTP request.
 */
@Named
public class HttpRequestHandler implements RequestHandler {

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {
        if (request.getDispatcherType().equals(DispatcherType.REQUEST)) {
            BitSensor.addContext("http.version", request.getProtocol());
            BitSensor.addContext("http.query", request.getQueryString());
            BitSensor.addContext("http.userAgent", request.getHeader("User-Agent"));
            BitSensor.addContext("http.referer", request.getHeader("Referer"));
            BitSensor.addContext("http.type", request.getMethod());
            BitSensor.addContext("http.acceptMedia", request.getHeader("Accept"));
            BitSensor.addContext("http.acceptCharset", request.getHeader("Accept-Charset"));
            BitSensor.addContext("http.acceptEncoding", request.getHeader("Accept-Encoding"));
            BitSensor.addContext("http.acceptLanguage", request.getHeader("Accept-Language"));
            BitSensor.addContext("http.pathInfo", request.getPathInfo());
            BitSensor.addContext("http.https", Boolean.toString(request.isSecure()));
            BitSensor.addContext("authentication.type", request.getAuthType());
            BitSensor.addContext("authentication.user", request.getRemoteUser());
            BitSensor.addEndpoint("address", request.getLocalAddr());
            BitSensor.addEndpoint("name", request.getHeader("Host"));
            BitSensor.addEndpoint("software", request.getServletContext().getServerInfo());
            BitSensor.addEndpoint("port", Integer.toString(request.getServerPort()));
            BitSensor.addEndpoint("uri", request.getRequestURI());
        } else if (request.getDispatcherType().equals(DispatcherType.FORWARD)) {
            BitSensor.addEndpoint("forward.uri", request.getRequestURI());
        }

    }

    /**
     * @return {@link ExecutionMoment#PRE_HANDLE}
     */
    @Override
    public ExecutionMoment getExecutionMoment() {
        return ExecutionMoment.PRE_HANDLE;
    }
}
