/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.blocking;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitsensor.lib.entity.BlockedAttacker;
import io.bitsensor.lib.entity.Identifiable;
import io.bitsensor.lib.jackson.JacksonConfig;
import io.bitsensor.plugins.java.blocking.BlockingEvent;
import io.bitsensor.plugins.java.blocking.BlockingManager;
import io.bitsensor.plugins.java.core.BitSensorException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.rabbit.AsyncRabbitTemplate;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Component
public class BlockingManagerImpl
implements BlockingManager,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockingManager.class);
    private final ApplicationEventPublisher publisher;
    private final DirectExchange rpcExchange;
    private final AsyncRabbitTemplate asyncTemplate;
    private Map<String, BlockedAttacker> blockedAttackerMap = new ConcurrentHashMap<String, BlockedAttacker>();
    private ObjectMapper mapper = JacksonConfig.objectMapper();

    @Autowired
    public BlockingManagerImpl(ApplicationEventPublisher publisher, DirectExchange rpcExchange, RabbitTemplate template, AsyncRabbitTemplate asyncTemplate) {
        this.publisher = publisher;
        this.rpcExchange = rpcExchange;
        this.asyncTemplate = asyncTemplate;
    }

    @Override
    public Map<String, BlockedAttacker> getBlacklist() {
        return this.blockedAttackerMap;
    }

    @Override
    public BlockedAttacker getBlocking(String id) {
        return this.blockedAttackerMap.get(id);
    }

    @Override
    public void fetchBlacklist() {
        this.doFetchBlacklist().addCallback((ListenableFutureCallback)new ListenableFutureCallback<Object>(){

            public void onFailure(Throwable ex) {
                LOGGER.error("Failed fetching blacklist from BitSensor", ex);
                BlockingManagerImpl.this.publisher.publishEvent((ApplicationEvent)new BlockingEvent(this, BlockingEvent.Type.FETCH, false));
            }

            public void onSuccess(Object result) {
                if (result == null) {
                    this.onFailure((Throwable)new BitSensorException("Blacklist fetch returns null."));
                    return;
                }
                List res = (List)BlockingManagerImpl.this.mapper.convertValue(result, (TypeReference)new TypeReference<List<Identifiable<BlockedAttacker>>>(){});
                BlockingManagerImpl.this.blockedAttackerMap.clear();
                res.forEach(i -> {
                    BlockedAttacker cfr_ignored_0 = (BlockedAttacker)BlockingManagerImpl.this.blockedAttackerMap.put(i.getIdentifier(), i.getIdentifiable());
                });
                BlockingManagerImpl.this.publisher.publishEvent((ApplicationEvent)new BlockingEvent(this, BlockingEvent.Type.FETCH, BlockingManagerImpl.this.blockedAttackerMap));
            }
        });
    }

    private AsyncRabbitTemplate.RabbitConverterFuture<Object> doFetchBlacklist() {
        String message = "getAll";
        return this.asyncTemplate.convertSendAndReceive(this.rpcExchange.getName(), "rpc", (Object)message);
    }

    @RabbitListener(queues={"#{blacklistAddQueue.name}"})
    public void receiveAdd(Identifiable<BlockedAttacker> attacker) throws InterruptedException {
        this.blockedAttackerMap.put(attacker.getIdentifier(), (BlockedAttacker)attacker.getIdentifiable());
        this.publisher.publishEvent((ApplicationEvent)new BlockingEvent(this, BlockingEvent.Type.ADD, attacker));
    }

    @RabbitListener(queues={"#{blacklistUpdateQueue.name}"})
    public void receiveUpdate(Identifiable<BlockedAttacker> attacker) throws InterruptedException {
        this.blockedAttackerMap.put(attacker.getIdentifier(), (BlockedAttacker)attacker.getIdentifiable());
        this.publisher.publishEvent((ApplicationEvent)new BlockingEvent(this, BlockingEvent.Type.UPDATE, attacker));
    }

    @RabbitListener(queues={"#{blacklistDeleteQueue.name}"})
    public void receiveDelete(String id) throws InterruptedException {
        if (id == null) {
            return;
        }
        this.blockedAttackerMap.remove(id);
        this.publisher.publishEvent((ApplicationEvent)new BlockingEvent(this, BlockingEvent.Type.DELETE, id));
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.fetchBlacklist();
    }
}

