/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.blocking;

import io.bitsensor.plugins.java.blocking.BlockingManager;
import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.handler.Handler;
import io.bitsensor.plugins.java.http.AccessDeniedException;
import io.bitsensor.plugins.java.http.filter.handler.RequestHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order
public class BlockingHandler
implements RequestHandler {
    @Autowired
    BlockingManager manager;
    @Value(value="${bitsensor.blocking.message:This request has been blocked by BitSensor.}")
    private String message;

    public void handle(HttpServletRequest request, HttpServletResponse response) {
        this.manager.getBlacklist().forEach((s, attacker) -> {
            if (attacker.match(BitSensor.getDatapointBuilder().build())) {
                BitSensor.addEndpoint((String)"blocking.id", (String)s);
                throw new AccessDeniedException(this.message);
            }
        });
    }

    public Handler.ExecutionMoment getExecutionMoment() {
        return Handler.ExecutionMoment.PRE_HANDLE;
    }
}

