/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.blocking;

import io.bitsensor.lib.jackson.JacksonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.AsyncRabbitTemplate;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(value={"io.bitsensor.plugins.java.blocking"})
@EnableRabbit
public class BlockingConfig {
    public static final String TOPIC_EXCHANGE = "blacklist.topic";
    public static final String ADD_QUEUE = "add";
    public static final String UPDATE_QUEUE = "update";
    public static final String DELETE_QUEUE = "delete";
    public static final String RPC_EXCHANGE = "blacklist.rpc";
    public static final String RPC_REQUEST_QUEUE = "blacklist.rpc.requests";
    public static final String RPC_REPLY_QUEUE = "blacklist.rpc.replies";
    public static final String RPC_ROUTING_KEY = "rpc";
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockingConfig.class);

    public static class ClientConfig {
        @Bean
        public DirectExchange rpcExchange() {
            return new DirectExchange(BlockingConfig.RPC_EXCHANGE);
        }

        @Bean
        public Queue rpcReplyQueue() {
            return new Queue(BlockingConfig.RPC_REPLY_QUEUE);
        }

        @Bean
        public Queue rpcRequestQueue() {
            return new Queue(BlockingConfig.RPC_REQUEST_QUEUE);
        }

        @Bean
        public Binding binding(DirectExchange directExchange, Queue rpcRequestQueue) {
            return BindingBuilder.bind((Queue)rpcRequestQueue).to(directExchange).with(BlockingConfig.RPC_ROUTING_KEY);
        }

        @Bean
        public TopicExchange topicExchange() {
            return new TopicExchange(BlockingConfig.TOPIC_EXCHANGE);
        }

        @Bean
        public Queue blacklistAddQueue() {
            return new AnonymousQueue();
        }

        @Bean
        public Queue blacklistDeleteQueue() {
            return new AnonymousQueue();
        }

        @Bean
        public Queue blacklistUpdateQueue() {
            return new AnonymousQueue();
        }

        @Bean
        public Binding binding1(TopicExchange topicExchange, Queue blacklistAddQueue) {
            return BindingBuilder.bind((Queue)blacklistAddQueue).to(topicExchange).with(BlockingConfig.ADD_QUEUE);
        }

        @Bean
        public Binding binding2(TopicExchange topicExchange, Queue blacklistUpdateQueue) {
            return BindingBuilder.bind((Queue)blacklistUpdateQueue).to(topicExchange).with(BlockingConfig.UPDATE_QUEUE);
        }

        @Bean
        public Binding binding3(TopicExchange topicExchange, Queue blacklistDeleteQueue) {
            return BindingBuilder.bind((Queue)blacklistDeleteQueue).to(topicExchange).with(BlockingConfig.DELETE_QUEUE);
        }
    }

    public static class RabbitMqConfig {
        @Value(value="${bitsensor.blocking.host:localhost}")
        private String host;
        @Value(value="${bitsensor.blocking.port:5672}")
        private int port;
        @Value(value="${bitsensor.blocking.username:guest}")
        private String username;
        @Value(value="${bitsensor.blocking.password:guest}")
        private String password;
        @Value(value="${bitsensor.blocking.virtual-host:/}")
        private String virtualHost;

        @Bean
        public ConnectionFactory connectionFactory() {
            CachingConnectionFactory connectionFactory = new CachingConnectionFactory(this.host, this.port);
            connectionFactory.setUsername(this.username);
            connectionFactory.setPassword(this.password);
            connectionFactory.setVirtualHost(this.virtualHost);
            LOGGER.info("BitSensor connects: {}@{}:{}/{}", new Object[]{this.username, this.host, this.port, this.virtualHost});
            return connectionFactory;
        }

        @Bean
        public RabbitAdmin rabbitAdmin(ConnectionFactory connectionFactory) {
            RabbitAdmin rabbitAdmin = new RabbitAdmin(connectionFactory);
            rabbitAdmin.afterPropertiesSet();
            return rabbitAdmin;
        }

        @Bean
        public SimpleRabbitListenerContainerFactory rabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
            SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
            factory.setConnectionFactory(connectionFactory);
            factory.setMessageConverter(this.jsonMessageConverter());
            return factory;
        }

        @Bean
        public MessageConverter jsonMessageConverter() {
            return new Jackson2JsonMessageConverter(JacksonConfig.objectMapper());
        }

        @Bean
        public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory) {
            RabbitTemplate template = new RabbitTemplate(connectionFactory);
            template.setMessageConverter(this.jsonMessageConverter());
            return template;
        }

        @Bean
        public AsyncRabbitTemplate asyncRabbitTemplate(ConnectionFactory connectionFactory, RabbitTemplate rabbitTemplate) {
            SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
            listenerContainer.setQueueNames(new String[]{BlockingConfig.RPC_REPLY_QUEUE});
            AsyncRabbitTemplate template = new AsyncRabbitTemplate(rabbitTemplate, listenerContainer);
            return template;
        }
    }
}

