package io.bitsensor.plugins.java.blocking;

import io.bitsensor.lib.entity.BlockedAttacker;

import java.util.Map;

/**
 * Blocking manager that keeps track of a blacklist containing blocked attackers.
 */
public interface BlockingManager {

    /**
     * Returns a map of blocked attackers stored in memory.
     *
     * @return blocked attacker map.
     */
    Map<String, BlockedAttacker> getBlacklist();

    /**
     * Returns a blocked attacker stored in the blacklist map.
     *
     * @param id identifier of the blocked attacker which was generated when added the blocked attacker to
     *           Elasticsearch.
     * @return the blocked attacker.
     */
    BlockedAttacker getBlocking(String id);

    /**
     * Fetches blacklist.
     */
    void fetchBlacklist();
}
