package io.bitsensor.plugins.java.blocking;

import org.springframework.context.ApplicationEvent;

public class BlockingEvent extends ApplicationEvent {

    private Type type;
    private transient Object message;

    public BlockingEvent(Object source, Type type, Object message) {
        super(source);
        this.type = type;
        this.message = message;
    }

    public Type getType() {
        return type;
    }

    public Object getMessage() {
        return message;
    }

    @Override
    public String toString() {
        return "BlockingEvent{" +
                "type='" + type.value() + "\'}";
    }

    public enum Type {
        ADD("add"),
        DELETE("delete"),
        UPDATE("update"),
        FETCH("fetch");

        private final String value;

        Type(String s) {
            value = s;
        }

        public String value() {
            return value;
        }
    }
}
