package io.bitsensor.plugins.java.blocking;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.http.AccessDeniedException;
import io.bitsensor.plugins.java.http.filter.handler.RequestHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Component
@Order
public class BlockingHandler implements RequestHandler {

    @Autowired
    BlockingManager manager;

    @Value("${bitsensor.blocking.message:This request has been blocked by BitSensor.}")
    private String message;

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) {
        manager.getBlacklist().forEach((s, attacker) -> {
            if (attacker.match(BitSensor.getDatapointBuilder().build())) {
                BitSensor.addEndpoint("blocking.id", s);

                throw new AccessDeniedException(message);
            }
        });
    }

    @Override
    public ExecutionMoment getExecutionMoment() {
        return ExecutionMoment.PRE_HANDLE;
    }
}
