package io.bitsensor.plugins.java.aspectj;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.inject.Inject;

@Aspect
public class DisableBitSensorAspect {
    private final static Logger LOGGER = LoggerFactory.getLogger(DisableBitSensorAspect.class);

    @Inject
    private DisableBitSensorInterceptor disableBitSensorInterceptor;

    @Pointcut("execution(* *(..))")
    public void anyMethod() {
    }

    @Pointcut("@annotation(io.bitsensor.plugins.java.core.annotation.state.DisableBitSensor) && anyMethod()")
    public void methodWithAnnotation() {
    }

    @Pointcut("@within(io.bitsensor.plugins.java.core.annotation.state.DisableBitSensor) && anyMethod()")
    public void classWithAnnotation() {
    }

    @Around("methodWithAnnotation() || classWithAnnotation()")
    public Object disableBitSensorPointcut(ProceedingJoinPoint joinPoint) throws Throwable {
        if (disableBitSensorInterceptor == null) {
            if (!isRecursiveCall(joinPoint)) {
                LOGGER.error("DisableBitSensorInterceptor is not initialized, @DisableBitSensor is not active yet");
            }
            return joinPoint.proceed();
        }
        return disableBitSensorInterceptor.invoke(joinPoint);
    }

    private boolean isRecursiveCall(ProceedingJoinPoint joinPoint) {
        return joinPoint.getSignature().getDeclaringType().isAnnotationPresent(io.bitsensor.plugins.java.core.annotation.state.DisableBitSensor.class);
    }
}
