/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.aspectj;

import io.bitsensor.plugins.java.core.BitSensor;
import io.bitsensor.plugins.java.core.annotation.state.DisableBitSensor;
import java.lang.reflect.Method;
import javax.inject.Named;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DisableBitSensorInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisableBitSensorInterceptor.class);

    public Object invoke(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        String reason = "";
        if (this.annotationPresentOnClass(proceedingJoinPoint)) {
            reason = " due to class " + proceedingJoinPoint.getSignature().getDeclaringType().getName();
        }
        if (this.annotationPresentOnMethod(proceedingJoinPoint)) {
            reason = " due to method " + ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod().getName();
        }
        if (this.isForEntireRequest(proceedingJoinPoint)) {
            LOGGER.trace("@DisableBitSensor triggered for entire thread" + reason);
            BitSensor.clear();
            BitSensor.setDisabled();
            return proceedingJoinPoint.proceed();
        }
        LOGGER.trace("@DisableBitSensor triggered temporarily" + reason);
        BitSensor.setDisabled();
        Object proceed = proceedingJoinPoint.proceed();
        BitSensor.setEnabled();
        return proceed;
    }

    private boolean isForEntireRequest(ProceedingJoinPoint joinPoint) {
        if (this.annotationPresentOnMethod(joinPoint)) {
            return this.getDisableBitSensorForMethod(joinPoint).forEntireRequest();
        }
        return this.annotationPresentOnClass(joinPoint) && this.getDisableBitSensorForClass(joinPoint).forEntireRequest();
    }

    private boolean annotationPresentOnClass(ProceedingJoinPoint joinPoint) {
        return joinPoint.getThis().getClass().isAnnotationPresent(DisableBitSensor.class);
    }

    private boolean annotationPresentOnMethod(ProceedingJoinPoint joinPoint) {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        return method.isAnnotationPresent(DisableBitSensor.class);
    }

    private DisableBitSensor getDisableBitSensorForClass(ProceedingJoinPoint joinPoint) {
        return joinPoint.getThis().getClass().getAnnotation(DisableBitSensor.class);
    }

    private DisableBitSensor getDisableBitSensorForMethod(ProceedingJoinPoint joinPoint) {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        return method.getAnnotation(DisableBitSensor.class);
    }
}

