package io.bitsensor.plugins.java.connectors.json;

import io.bitsensor.lib.entity.proto.Datapoint;
import io.bitsensor.lib.entity.proto.Datapoint.Builder;
import io.bitsensor.plugins.java.core.connectors.AbstractApiCollector;
import io.bitsensor.plugins.java.core.logging.NoLog;
import io.bitsensor.proto.shaded.com.google.gson.JsonObject;
import io.bitsensor.proto.shaded.com.google.protobuf.InvalidProtocolBufferException;
import io.bitsensor.proto.shaded.com.google.protobuf.util.JsonFormat;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

import javax.inject.Named;
import javax.inject.Singleton;
import java.io.IOException;

import static java.lang.String.valueOf;

@Named
@Singleton
@NoLog
public class BitSensorConnector extends AbstractApiCollector {
    @Value("${bitsensor.apiconnector.http.port:8080}")
    private int port;

    private final static Logger LOGGER = LoggerFactory.getLogger(BitSensorConnector.class.getName());

    private final AsyncHttpClient asyncHttpClient = new DefaultAsyncHttpClient();

    private void log(Builder datapointBuilder) throws InvalidProtocolBufferException {
        if (datapointBuilder == null)
            return;
        if (asyncHttpClient.isClosed()) {
            LOGGER.error("AsyncHttpClient is already closed. Datapoint not being sent");
            return;
        }

        String data = JsonFormat.printer().print(datapointBuilder.build());
        JsonObject jsonObject = new JsonObject();

        /*PublicKey publicKey = OpenSSLInterop.publicKeyFromFile(mPublicKey);
        byte[] key = new byte[256];
        byte[] encryptedData = InputConverter.encryptData(data, publicKey, key);

        jsonObject.addProperty("data", new String(Base64.getEncoder().encode(encryptedData)));
        jsonObject.addProperty("encryption", true);
        jsonObject.addProperty("key", new String(Base64.getEncoder().encode(key)));*/

        jsonObject.addProperty("data", data);

        //HttpEntity<String> requestEntity = new HttpEntity<>(jsonObject.toString());

        //LOGGER.trace(getHost() + "\n" + data);

        String body = jsonObject.toString();

        asyncHttpClient
                .preparePost(getEndpointUrl())
                .setHeader("Content-Type", "application/json")
                .setHeader("Content-Length", valueOf(body.length()))
                .setBody(body)
                .execute(new AsyncCompletionHandler<Integer>() {

                    @Override
                    public Integer onCompleted(Response response) throws Exception {

                        if (response.getStatusCode() / 100 == 2) {
                            if (LOGGER.isDebugEnabled())
                                LOGGER.debug("Sent datapoint. [{}]", response.getStatusCode());
                        } else {
                            LOGGER.error("Sending datapoint unsuccessful. [" + response.getStatusCode() + "]");
                        }
                        return response.getStatusCode();
                    }

                    @Override
                    public void onThrowable(Throwable t) {
                        LOGGER.error("Sending datapoint failure. " + t.getMessage());
                    }
                });
    }

    private String getEndpointUrl() {
        return "http://" + getHost() + ":" + port + "/log";
    }

    /**
     * Sends a {@link Datapoint} to the BitSensor servers.
     *
     * @param datapointBuilder The DataPoint to send.
     */
    @Override
    public void send(Builder datapointBuilder) {
        if (datapointBuilder == null)
            return;

        try {
            log(datapointBuilder);
        } catch (Exception e) {
            LOGGER.error("Could not log DataPoint", e);
        }
    }

    @Override
    public void shutdown() throws InterruptedException, IOException {
        super.shutdown();

        if (!asyncHttpClient.isClosed())
            asyncHttpClient.close();
    }

}
