/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.plugins.java.connectors.json;

import io.bitsensor.lib.entity.proto.Datapoint;
import io.bitsensor.plugins.java.core.connectors.AbstractApiCollector;
import io.bitsensor.plugins.java.core.logging.NoLog;
import io.bitsensor.proto.shaded.com.google.gson.JsonObject;
import io.bitsensor.proto.shaded.com.google.protobuf.InvalidProtocolBufferException;
import io.bitsensor.proto.shaded.com.google.protobuf.MessageOrBuilder;
import io.bitsensor.proto.shaded.com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@Named
@Singleton
@NoLog
public class BitSensorConnector
extends AbstractApiCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BitSensorConnector.class.getName());
    private final AsyncHttpClient asyncHttpClient = new DefaultAsyncHttpClient();

    private void log(Datapoint.Builder datapointBuilder) throws InvalidProtocolBufferException {
        if (datapointBuilder == null) {
            return;
        }
        if (this.asyncHttpClient.isClosed()) {
            LOGGER.error("AsyncHttpClient is already closed. Datapoint not being sent");
            return;
        }
        String data = JsonFormat.printer().print((MessageOrBuilder)datapointBuilder.build());
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("data", data);
        String body = jsonObject.toString();
        ((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.asyncHttpClient.preparePost(this.getUri()).setHeader((CharSequence)"Content-Type", "application/json")).setHeader((CharSequence)"Content-Length", String.valueOf(body.length()))).setBody(body)).execute((AsyncHandler)new AsyncCompletionHandler<Integer>(){

            public Integer onCompleted(Response response) throws Exception {
                if (response.getStatusCode() / 100 == 2) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Sent datapoint. [{}]", (Object)response.getStatusCode());
                    }
                } else {
                    LOGGER.error("Sending datapoint unsuccessful. [" + response.getStatusCode() + "]");
                }
                return response.getStatusCode();
            }

            public void onThrowable(Throwable t) {
                LOGGER.error("Sending datapoint failure. " + t.getMessage());
            }
        });
    }

    public void send(Datapoint.Builder datapointBuilder) {
        if (datapointBuilder == null) {
            return;
        }
        try {
            this.log(datapointBuilder);
        }
        catch (Exception e) {
            LOGGER.error("Could not log DataPoint", (Throwable)e);
        }
    }

    @Value(value="${bitsensor.uri}")
    public void setUri(String uri) {
        if (!uri.toLowerCase().matches("^\\w+://.*")) {
            uri = "http://" + uri;
        }
        uri = uri + "/log";
        super.setUri(uri);
    }

    public void shutdown() throws InterruptedException, IOException {
        super.shutdown();
        if (!this.asyncHttpClient.isClosed()) {
            this.asyncHttpClient.close();
        }
    }
}

