/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.lib.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import io.bitsensor.lib.jackson.protobuf.ProtobufModule;
import io.bitsensor.proto.shaded.com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.AbstractMap;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.support.json.Jackson2JsonObjectMapper;

@Configuration
public class JacksonConfig {
    @Bean
    public static Module configureModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(AbstractMap.SimpleEntry.class, (JsonSerializer)new AbstractMapSimpleEntrySerializer());
        module.addSerializer(Interval.class, (JsonSerializer)new IntervalSerializer());
        module.addSerializer(DateTime.class, (JsonSerializer)new JodaDateTimeAsMillisecondsSerializer());
        module.setMixInAnnotation(AbstractMap.SimpleEntry.class, Mixin.class);
        return module;
    }

    @Bean
    public static Module protobufModule() {
        return new ProtobufModule(JsonFormat.printer().omittingInsignificantWhitespace().includingDefaultValueFields().preservingProtoFieldNames(), JsonFormat.parser().ignoringUnknownFields());
    }

    @Bean
    public static ObjectMapper objectMapper() {
        return new ObjectMapper().registerModule(JacksonConfig.configureModule()).registerModule(JacksonConfig.protobufModule()).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setDateFormat((DateFormat)((Object)new ISO8601DateFormatMilliseconds()));
    }

    @Bean
    public static Jackson2JsonObjectMapper jackson2JsonObjectMapper() {
        return new Jackson2JsonObjectMapper(JacksonConfig.objectMapper());
    }

    public static class ISO8601DateFormatMilliseconds
    extends ISO8601DateFormat {
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            String value = ISO8601Utils.format((Date)date, (boolean)true);
            toAppendTo.append(value);
            return toAppendTo;
        }
    }

    public static class JodaDateTimeAsMillisecondsSerializer
    extends JsonSerializer<DateTime> {
        public void serialize(DateTime dateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(dateTime.getMillis());
        }
    }

    public static class IntervalSerializer
    extends JsonSerializer<Interval> {
        public void serialize(Interval interval, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("start", (Object)interval.getStart());
            jsonGenerator.writeObjectField("end", (Object)interval.getEnd());
            jsonGenerator.writeEndObject();
        }
    }

    public static class AbstractMapSimpleEntrySerializer
    extends JsonSerializer<AbstractMap.SimpleEntry> {
        public void serialize(AbstractMap.SimpleEntry simpleEntry, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("key", simpleEntry.getKey());
            jsonGenerator.writeObjectField("value", simpleEntry.getValue());
            jsonGenerator.writeEndObject();
        }
    }

    static abstract class Mixin<K, V> {
        public Mixin(@JsonProperty(value="key") K key, @JsonProperty(value="value") V value) {
        }
    }
}

