/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.lib.util;

import com.google.gson.JsonObject;
import io.bitsensor.lib.entity.Constants;
import io.bitsensor.lib.entity.proto.Datapoint;
import io.bitsensor.lib.entity.proto.Detection;
import io.bitsensor.lib.entity.proto.DetectionOrBuilder;
import io.bitsensor.lib.entity.proto.Error;
import io.bitsensor.lib.entity.proto.ErrorOrBuilder;
import io.bitsensor.lib.entity.util.ProtoUtils;
import io.bitsensor.proto.shaded.com.google.protobuf.MessageOrBuilder;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.hash.MurmurHash3;

public class DatapointUtils {
    public static void generateHash(Datapoint.Builder datapoint) {
        datapoint.getErrorsBuilderList().forEach(DatapointUtils::generateHash);
        datapoint.getDetectionsBuilderList().forEach(detection -> {
            DatapointUtils.generateHash(detection);
            DatapointUtils.generateRuleHash(detection);
        });
    }

    public static <T extends ErrorOrBuilder> T generateHash(T object) {
        if (object instanceof Error.Builder) {
            return (T)((Error.Builder)object).setHash(DatapointUtils.createHash(object, new String[0]));
        }
        if (object instanceof Error) {
            return (T)DatapointUtils.generateHash(((Error)object).toBuilder()).build();
        }
        return object;
    }

    public static <T extends DetectionOrBuilder> T generateHash(T object) {
        if (object instanceof Detection.Builder) {
            return (T)((Detection.Builder)object).setHash(DatapointUtils.createHash(object, Constants.Detection.DETECTION_HASH_FIELDS));
        }
        if (object instanceof Detection) {
            return (T)DatapointUtils.generateHash(((Detection)object).toBuilder()).build();
        }
        return object;
    }

    public static <T extends DetectionOrBuilder> T generateRuleHash(T object) {
        if (object.getRuleHash() != 0L) {
            return object;
        }
        if (object instanceof Detection.Builder) {
            return (T)((Detection.Builder)object).setRuleHash(DatapointUtils.createHash(object, Constants.Detection.DETECTION_RULE_FIELDS));
        }
        if (object instanceof Detection) {
            return (T)DatapointUtils.generateRuleHash(((Detection)object).toBuilder()).build();
        }
        return object;
    }

    private static long createHash(MessageOrBuilder message, String ... onlyFields) {
        JsonObject json = ProtoUtils.proto2JsonWithoutHashes((MessageOrBuilder)message);
        List<String> onlyFieldsList = Arrays.asList(onlyFields);
        if (onlyFields.length > 0) {
            json.entrySet().removeIf(entry -> !onlyFieldsList.contains(entry.getKey()));
        }
        BytesRef bytes = new BytesRef((CharSequence)json.toString());
        return MurmurHash3.hash128((byte[])bytes.bytes, (int)bytes.offset, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)new MurmurHash3.Hash128()).h1;
    }
}

