/*
 * Decompiled with CFR 0.152.
 */
package io.bitsensor.lib.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.bitsensor.lib.util.exception.DataModelException;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputConverter.class);

    public static JsonObject unflatten(String json) throws DataModelException {
        return InputConverter.unflatten(json, new String[0]);
    }

    public static JsonObject unflatten(String json, String[] excludeFields) throws DataModelException {
        JsonElement partlyFlattenedObject = new JsonParser().parse(json);
        try {
            return InputConverter.unflatten(partlyFlattenedObject, excludeFields);
        }
        catch (DataModelException ex) {
            LOGGER.error(json, (Throwable)ex);
            throw ex;
        }
    }

    public static JsonObject unflatten(JsonElement element) throws DataModelException {
        return InputConverter.unflatten(element, new String[0]);
    }

    public static JsonObject unflatten(JsonElement element, String[] excludeFields) throws DataModelException {
        JsonObject flattened = InputConverter.flatten(element);
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry nameElementEntry : flattened.getAsJsonObject().entrySet()) {
            String name = (String)nameElementEntry.getKey();
            JsonElement value = (JsonElement)nameElementEntry.getValue();
            InputConverter.unflattenRaw(name.split("\\."), value, jsonObject, excludeFields, true);
        }
        return jsonObject;
    }

    public static void unflatten(String[] parts, String value, JsonObject parent) throws DataModelException {
        InputConverter.unflattenRaw(parts, (JsonElement)(value != null ? new JsonPrimitive(value) : new JsonNull()), parent, new String[0], true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unflattenRaw(String[] parts, JsonElement value, JsonObject parent, String[] excludeFields, boolean recursive) throws DataModelException {
        if (parts.length <= 0) return;
        String key = parts[0];
        if ((parts = InputConverter.removeFirst(parts)).length == 0) {
            if (value.isJsonArray()) {
                JsonArray newArray = new JsonArray();
                for (JsonElement element : value.getAsJsonArray()) {
                    newArray.add((JsonElement)(element.isJsonObject() ? InputConverter.unflatten(element, excludeFields) : element));
                }
                value = newArray;
            }
            parent.add(key, value);
            return;
        } else if (parent.has(key)) {
            JsonElement jsonElement = parent.get(key);
            if (jsonElement.isJsonPrimitive()) {
                String valueToNest = jsonElement.getAsString();
                JsonObject nestedObject = new JsonObject();
                nestedObject.addProperty("_", valueToNest);
                parent.remove(key);
                parent.add(key, (JsonElement)nestedObject);
                jsonElement = parent.get(key);
            }
            if (!jsonElement.isJsonObject()) throw new DataModelException("An object in the data model is also assigned a Array value. " + key + "." + String.join((CharSequence)".", parts) + ": " + jsonElement.toString());
            InputConverter.unflattenRaw(parts, value, jsonElement.getAsJsonObject(), excludeFields, recursive && !Arrays.asList(excludeFields).contains(key));
            return;
        } else if (!recursive) {
            parent.add(key + "." + String.join((CharSequence)".", parts), value);
            return;
        } else {
            JsonObject jsonObject = new JsonObject();
            InputConverter.unflattenRaw(parts, value, jsonObject, excludeFields, recursive && !Arrays.asList(excludeFields).contains(key));
            parent.add(key, (JsonElement)jsonObject);
        }
    }

    public static JsonObject flatten(String json) {
        JsonElement parsedJson = new JsonParser().parse(json);
        return InputConverter.flatten(parsedJson);
    }

    public static JsonObject flatten(JsonElement element) {
        JsonObject jsonObject = new JsonObject();
        InputConverter.flatten(element, "", jsonObject);
        return jsonObject;
    }

    public static void flatten(JsonElement object, String prefix, JsonObject parent) {
        if (object.isJsonObject()) {
            if (object.getAsJsonObject().entrySet().size() == 0 && !prefix.equals("")) {
                parent.add(prefix, object);
            }
            for (Map.Entry entry : object.getAsJsonObject().entrySet()) {
                InputConverter.flatten((JsonElement)entry.getValue(), (prefix.isEmpty() ? "" : prefix + ".") + (String)entry.getKey(), parent);
            }
        } else {
            if (object.isJsonArray()) {
                JsonArray newArray = new JsonArray();
                for (JsonElement element : object.getAsJsonArray()) {
                    newArray.add((JsonElement)(element.isJsonObject() ? InputConverter.flatten(element) : element));
                }
                object = newArray;
            }
            parent.add(prefix, object);
        }
    }

    private static String[] removeFirst(String[] parts) {
        String[] strippedParts = new String[parts.length - 1];
        System.arraycopy(parts, 1, strippedParts, 0, parts.length - 1);
        return strippedParts;
    }
}

