package io.bitsensor.lib.util.streams;

import java.util.function.LongConsumer;

public class MinMax implements LongConsumer {
    public Long min = Long.MAX_VALUE;
    public Long max = Long.MIN_VALUE;

    @Override
    public void accept(long value) {
        this.min = Math.min(min, value);
        this.max = Math.max(max, value);
    }

    public void combine(MinMax other) {
        this.min = Math.min(min, other.min);
        this.max = Math.max(max, other.max);
    }
}
