/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client.sign.bc;

import io.bitexpress.openapi.client.sign.AbstractKeyReader;
import java.io.IOException;
import java.io.Reader;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class KeyReaderBcImpl
extends AbstractKeyReader {
    public static final KeyReaderBcImpl INSTANCE = new KeyReaderBcImpl();
    private static JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");

    private KeyReaderBcImpl() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PublicKey readPublicKey(Reader reader) {
        try (PEMParser pemParser = new PEMParser(reader);){
            SubjectPublicKeyInfo ki = (SubjectPublicKeyInfo)pemParser.readObject();
            PublicKey publicKey = converter.getPublicKey(ki);
            return publicKey;
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Pair<PrivateKey, PublicKey> readPkcs1KeyPair(Reader reader) {
        try (PEMParser pemParser = new PEMParser(reader);){
            PEMKeyPair kp = (PEMKeyPair)pemParser.readObject();
            PrivateKey privateKey = converter.getPrivateKey(kp.getPrivateKeyInfo());
            PublicKey publicKey = converter.getPublicKey(kp.getPublicKeyInfo());
            Pair pair = Pair.of((Object)privateKey, (Object)publicKey);
            return pair;
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PrivateKey readPkcs8PrivateKey(Reader reader) {
        try (PEMParser pemParser = new PEMParser(reader);){
            Object o = pemParser.readObject();
            PrivateKey privateKey = converter.getPrivateKey((PrivateKeyInfo)o);
            return privateKey;
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

