/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client.sign;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OaRsaSignatureTool {
    private static final Logger logger = LoggerFactory.getLogger(OaRsaSignatureTool.class);
    public static final String ALGORITHM = "SHA256withRSA";

    private OaRsaSignatureTool() {
    }

    public static byte[] sign(byte[] content, PrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance(ALGORITHM);
            signature.initSign(privateKey);
            signature.update(content);
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    public static String signHex(byte[] content, PrivateKey privateKey) {
        return Hex.encodeHexString((byte[])OaRsaSignatureTool.sign(content, privateKey));
    }

    public static String signUtf8ToHex(String content, PrivateKey privateKey) {
        String signature = OaRsaSignatureTool.signHex(content.getBytes(StandardCharsets.UTF_8), privateKey);
        logger.trace("content:{},signature:{}", (Object)content, (Object)signature);
        return signature;
    }

    public static boolean verify(byte[] content, byte[] expectedSignature, PublicKey publicKey) {
        try {
            Signature signature = Signature.getInstance(ALGORITHM);
            signature.initVerify(publicKey);
            signature.update(content);
            return signature.verify(expectedSignature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    public static boolean verifyHex(byte[] content, String expectedSignatureHex, PublicKey publicKey) {
        byte[] expectedSignBytes;
        try {
            expectedSignBytes = Hex.decodeHex((String)expectedSignatureHex);
        }
        catch (DecoderException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
        return OaRsaSignatureTool.verify(content, expectedSignBytes, publicKey);
    }

    public static boolean verifyUtf8WithHex(String content, String expectedSignatureHex, PublicKey publicKey) {
        return OaRsaSignatureTool.verifyHex(content.getBytes(StandardCharsets.UTF_8), expectedSignatureHex, publicKey);
    }
}

