/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client.sign;

import io.bitexpress.openapi.client.sign.KeyMaker;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractKeyMaker
implements KeyMaker {
    @Override
    public Pair<String, String> makePkcs1PemPair() {
        Pair<PrivateKey, PublicKey> pair = this.makePair();
        return this.exportPkcs1PemPair(pair);
    }

    @Override
    public Pair<String, String> makePkcs8PemPair() {
        Pair<PrivateKey, PublicKey> pair = this.makePair();
        return this.exportPkcs8PemPair(pair);
    }

    @Override
    public Pair<String, String> exportPemPair(Pair<PrivateKey, PublicKey> pair) {
        return this.exportPkcs1PemPair(pair);
    }

    @Override
    public Pair<String, String> makePemPair() {
        return this.makePkcs1PemPair();
    }

    @Override
    public void makePkcs1PemPair2File(String priavteKeyPemFile, String publicKeyPemFile) {
        Pair<String, String> makePemPair = this.makePkcs1PemPair();
        this.write2File(priavteKeyPemFile, publicKeyPemFile, makePemPair);
    }

    @Override
    public void makePkcs8PemPair2File(String privateKeyPemFile, String publicKeyPemFile) {
        Pair<String, String> makePemPair = this.makePkcs8PemPair();
        this.write2File(privateKeyPemFile, publicKeyPemFile, makePemPair);
    }

    private void write2File(String privateKeyPemFile, String publicKeyPemFile, Pair<String, String> pemPair) {
        try {
            FileUtils.writeStringToFile((File)new File(privateKeyPemFile), (String)((String)pemPair.getLeft()), (Charset)StandardCharsets.US_ASCII);
            FileUtils.writeStringToFile((File)new File(publicKeyPemFile), (String)((String)pemPair.getRight()), (Charset)StandardCharsets.US_ASCII);
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    @Override
    @Deprecated
    public void makePemPair2File(String priavteKeyPemFile, String publicKeyPemFile) {
        this.makePkcs1PemPair2File(priavteKeyPemFile, publicKeyPemFile);
    }

    @Override
    public Pair<String, String> exportPkcs1PemPair(Pair<PrivateKey, PublicKey> pair) {
        String privateKeyPem = this.exportKey((Key)pair.getLeft());
        String publicKeyPem = this.exportKey((Key)pair.getRight());
        return Pair.of((Object)privateKeyPem, (Object)publicKeyPem);
    }

    @Override
    public Pair<String, String> exportPkcs8PemPair(Pair<PrivateKey, PublicKey> pair) {
        String privateKeyPem = this.exportPkcs8Key((PrivateKey)pair.getLeft());
        String publicKeyPem = this.exportKey((Key)pair.getRight());
        return Pair.of((Object)privateKeyPem, (Object)publicKeyPem);
    }

    public abstract String exportKey(Key var1);

    public abstract String exportPkcs8Key(PrivateKey var1);
}

