/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client.notification;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.openapi.client.FromHolder;
import io.bitexpress.openapi.client.notification.GatewayNotificationParser;
import io.bitexpress.openapi.client.sign.OaRsaSignatureTool;
import io.bitexpress.openapi.model.ack.NotificationAck;
import io.bitexpress.openapi.model.content.OpenApiRequestContent;
import io.bitexpress.openapi.model.content.OpenApiRequestHeader;
import io.bitexpress.openapi.model.content.ServiceIndex;
import io.bitexpress.openapi.model.envelope.OpenApiEnvelope;
import java.io.IOException;
import java.security.PublicKey;
import java.util.function.Function;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayNotificationParserImpl
extends FromHolder
implements GatewayNotificationParser {
    private static final Logger logger = LoggerFactory.getLogger(GatewayNotificationParserImpl.class);
    private ObjectMapper objectMapper;
    private PublicKey serverSidePublicKey;
    private Function<ServiceIndex, JavaType> notificationJavaTypeFunction;

    @Override
    public <NOTIFY> OpenApiRequestContent<NOTIFY> parseNotification(String requestEnvelope) {
        OpenApiEnvelope openApiEnvelope = null;
        try {
            openApiEnvelope = (OpenApiEnvelope)this.objectMapper.readValue(requestEnvelope, OpenApiEnvelope.class);
            this.checkPrivilige(openApiEnvelope.getUid(), openApiEnvelope.getIssuerCode());
            this.verifySignature(openApiEnvelope);
            OpenApiRequestContent<JsonNode> openApiRequestContent = this.unmarshallRequestContent(openApiEnvelope.getContent());
            JavaType javaType = this.notificationJavaTypeFunction.apply(openApiRequestContent.getHeader().getServiceIndex());
            Validate.notNull((Object)javaType, (String)"javaType not found", (Object[])new Object[0]);
            return this.unmarshallBody(openApiRequestContent, javaType);
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    private void checkPrivilige(Long uid, String issuerCode) {
        Validate.isTrue((this.uid.equals(uid) || this.issuerCode.equals(issuerCode) ? 1 : 0) != 0, (String)"from mismatch,your uid:%s, incoming uid:%s,your issuerCode:%s, incoming issuerCode:%s", (Object[])new Object[]{this.uid, uid, this.issuerCode, issuerCode});
    }

    private void verifySignature(OpenApiEnvelope openApiEnvelope) {
        if (this.serverSidePublicKey == null) {
            logger.warn("skip verify signature");
            return;
        }
        boolean verify = OaRsaSignatureTool.verifyUtf8WithHex(openApiEnvelope.getContent(), openApiEnvelope.getSignature(), this.serverSidePublicKey);
        Validate.isTrue((boolean)verify, (String)"verify signature failure.", (Object[])new Object[0]);
    }

    private OpenApiRequestContent<JsonNode> unmarshallRequestContent(String content) throws IOException {
        JsonNode rootNode = this.objectMapper.readTree(content);
        JsonNode headerNode = rootNode.get("header");
        OpenApiRequestHeader openApiRequestHeader = (OpenApiRequestHeader)this.objectMapper.treeToValue((TreeNode)headerNode, OpenApiRequestHeader.class);
        OpenApiRequestContent openApiRequestContent = new OpenApiRequestContent();
        openApiRequestContent.setHeader(openApiRequestHeader);
        openApiRequestContent.setBody((Object)rootNode.get("body"));
        return openApiRequestContent;
    }

    private <T> OpenApiRequestContent<T> unmarshallBody(OpenApiRequestContent<JsonNode> requestContent, JavaType bodyType) {
        try {
            JsonParser jsonParser = this.objectMapper.treeAsTokens((TreeNode)requestContent.getBody());
            Object t = this.objectMapper.readValue(jsonParser, bodyType);
            OpenApiRequestContent requestContent2 = new OpenApiRequestContent();
            requestContent2.setHeader(requestContent.getHeader());
            requestContent2.setBody(t);
            return requestContent2;
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getAckString(boolean success) {
        try {
            return this.objectMapper.writeValueAsString((Object)this.getAck(success));
        }
        catch (JsonProcessingException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    @Override
    public NotificationAck getAck(boolean success) {
        NotificationAck ack = new NotificationAck();
        ack.setSuccess(success);
        return ack;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setServerSidePublicKey(PublicKey serverSidePublicKey) {
        this.serverSidePublicKey = serverSidePublicKey;
    }

    public void setNotificationJavaTypeFunction(Function<ServiceIndex, JavaType> notificationJavaTypeFunction) {
        this.notificationJavaTypeFunction = notificationJavaTypeFunction;
    }
}

