/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client.notification;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.openapi.client.BaseBuilder;
import io.bitexpress.openapi.client.notification.GatewayNotificationParser;
import io.bitexpress.openapi.client.notification.GatewayNotificationParserImpl;
import io.bitexpress.openapi.model.content.ServiceIndex;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.security.PublicKey;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public abstract class AbstractGatewayNotificationParserBuilder
extends BaseBuilder {
    private Resource serverSidePublicKeyResource;

    public GatewayNotificationParser build() {
        ObjectMapper objectMapper = this.createObjectMapper();
        GatewayNotificationParserImpl gatewayNotificationParser = new GatewayNotificationParserImpl();
        gatewayNotificationParser.setObjectMapper(objectMapper);
        gatewayNotificationParser.setUid(this.uid);
        gatewayNotificationParser.setIssuerCode(this.issuerCode);
        gatewayNotificationParser.setIssuer(this.issuer);
        gatewayNotificationParser.setServerSidePublicKey(this.readPublicKey());
        Function<ServiceIndex, JavaType> notificationJavaTypeFunction = this.getTypeFunction(objectMapper);
        gatewayNotificationParser.setNotificationJavaTypeFunction(notificationJavaTypeFunction);
        return gatewayNotificationParser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PublicKey readPublicKey() {
        try (InputStreamReader reader = new InputStreamReader(this.serverSidePublicKeyResource.getInputStream());){
            PublicKey publicKey = this.keyReader.readPublicKey(reader);
            return publicKey;
        }
        catch (IOException e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    public void setServerSidePublicKeyFilePath(Path serverSidePublicKeyFilePath) {
        this.setServerSidePublicKeyResource((Resource)new FileSystemResource(serverSidePublicKeyFilePath));
    }

    protected abstract Function<ServiceIndex, JavaType> getTypeFunction(ObjectMapper var1);

    public void setServerSidePublicKeyResource(Resource serverSidePublicKeyResource) {
        this.serverSidePublicKeyResource = serverSidePublicKeyResource;
    }
}

