/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client.sign;

import io.bitexpress.openapi.client.sign.KeyMaker;
import io.bitexpress.openapi.client.sign.KeyReader;
import io.bitexpress.openapi.client.sign.bc.KeyMakerBcImpl;
import io.bitexpress.openapi.client.sign.bc.KeyReaderBcImpl;
import io.bitexpress.openapi.client.sign.sc.KeyMakerScImpl;
import io.bitexpress.openapi.client.sign.sc.KeyReaderScImpl;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KeyMakerReaderTest {
    @Test
    void testBc() {
        this.exportPkcs1PemPairAndRead((KeyMaker)KeyMakerBcImpl.INSTANCE, (KeyReader)KeyReaderBcImpl.INSTANCE);
        this.exportPkcs8PemPairAndRead((KeyMaker)KeyMakerBcImpl.INSTANCE, (KeyReader)KeyReaderBcImpl.INSTANCE);
        KeyMakerBcImpl.INSTANCE.makePkcs1PemPair2File("target/pkcs1_private_key_file_bc.pem", "target/pkcs1_public_key_file_bc.pem");
        KeyMakerBcImpl.INSTANCE.makePkcs8PemPair2File("target/pkcs8_private_key_file_bc.pem", "target/pkcs8_public_key_file_bc.pem");
    }

    @Test
    void testSc() {
        this.exportPkcs1PemPairAndRead((KeyMaker)KeyMakerScImpl.INSTANCE, KeyReaderScImpl.INSTANCE);
        this.exportPkcs8PemPairAndRead((KeyMaker)KeyMakerScImpl.INSTANCE, KeyReaderScImpl.INSTANCE);
        KeyMakerScImpl.INSTANCE.makePkcs1PemPair2File("target/pkcs1_private_key_file_sc.pem", "target/pkcs1_public_key_file_sc.pem");
        KeyMakerScImpl.INSTANCE.makePkcs8PemPair2File("target/pkcs8_private_key_file_sc.pem", "target/pkcs8_public_key_file_sc.pem");
    }

    public void exportPkcs1PemPairAndRead(KeyMaker keyMaker, KeyReader keyReader) {
        Pair keyPair1 = keyMaker.makePair();
        Pair stringStringPair2 = keyMaker.exportPkcs1PemPair(keyPair1);
        Pair keyPair2 = keyReader.readPkcs1KeyPair((String)stringStringPair2.getLeft());
        Assertions.assertEquals((Object)keyPair1.getLeft(), (Object)keyPair2.getLeft());
        Assertions.assertEquals((Object)keyPair1.getRight(), (Object)keyPair2.getRight());
    }

    public void exportPkcs8PemPairAndRead(KeyMaker keyMaker, KeyReader keyReader) {
        Pair keyPair1 = keyMaker.makePair();
        Pair stringStringPair2 = keyMaker.exportPkcs8PemPair(keyPair1);
        PrivateKey privateKey = keyReader.readPkcs8PrivateKey((String)stringStringPair2.getLeft());
        PublicKey publicKey = keyReader.readPublicKey((String)stringStringPair2.getRight());
        Assertions.assertEquals((Object)keyPair1.getLeft(), (Object)privateKey);
        Assertions.assertEquals((Object)keyPair1.getRight(), (Object)publicKey);
    }

    public void writePkcs1ToFile(KeyMaker keyMaker, String privateKeyPath, String publicKeyPath) {
        keyMaker.makePkcs1PemPair2File(privateKeyPath, publicKeyPath);
    }
}

