/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client;

import io.bitexpress.openapi.client.GatewayClient;
import io.bitexpress.openapi.client.GatewayClientBuilder;
import io.bitexpress.openapi.client.sign.KeyReader;
import io.bitexpress.openapi.client.sign.bc.KeyReaderBcImpl;
import io.bitexpress.openapi.model.envelope.Issuer;
import java.nio.file.Paths;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GatewayClientBuilderTest {
    @Test
    public void readPkcs1Path() {
        GatewayClientBuilder builder = new GatewayClientBuilder();
        builder.setUid(Long.valueOf(1L));
        builder.setIssuerCode("1");
        builder.setIssuer(Issuer.builder().issuerType("it").issuerCode("ic").build());
        builder.setUrl("aaa");
        builder.setKeyReader((KeyReader)KeyReaderBcImpl.INSTANCE);
        builder.setPkcs1PrivateKeyPairFilePath(Paths.get("src/test/resources/pkcs1_private_key_file_bc.pem", new String[0]));
        GatewayClient gatewayClient = builder.build();
        Assert.assertNotNull((Object)gatewayClient);
    }

    @Test
    public void readPkcs8Path() {
        GatewayClientBuilder builder = new GatewayClientBuilder();
        builder.setUid(Long.valueOf(1L));
        builder.setIssuerCode("1");
        builder.setIssuer(Issuer.builder().issuerType("it").issuerCode("ic").build());
        builder.setUrl("aaa");
        builder.setKeyReader((KeyReader)KeyReaderBcImpl.INSTANCE);
        builder.setPkcs8PrivateKeyFilePath(Paths.get("src/test/resources/pkcs8_private_key_file_bc.pem", new String[0]));
        GatewayClient gatewayClient = builder.build();
        Assert.assertNotNull((Object)gatewayClient);
    }
}

