package io.bitexpress.openapi.client.sign.bc;

import io.bitexpress.openapi.client.sign.AbstractKeyReader;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

import java.io.IOException;
import java.io.Reader;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;

public class KeyReaderBcImpl extends AbstractKeyReader {
    public static final KeyReaderBcImpl INSTANCE = new KeyReaderBcImpl();
    private static JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");

    static {
        Security.addProvider(new BouncyCastleProvider());
    }


    private KeyReaderBcImpl() {
    }


    public PublicKey readPublicKey(Reader reader) {
        try (PEMParser pemParser = new PEMParser(reader)) {
            SubjectPublicKeyInfo ki = (SubjectPublicKeyInfo) pemParser.readObject();
            return converter.getPublicKey(ki);
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

    @Override
    public Pair<PrivateKey, PublicKey> readPkcs1KeyPair(Reader reader) {
        try (PEMParser pemParser = new PEMParser(reader)) {
            PEMKeyPair kp = (PEMKeyPair) pemParser.readObject();
            PrivateKey privateKey = converter.getPrivateKey(kp.getPrivateKeyInfo());
            PublicKey publicKey = converter.getPublicKey(kp.getPublicKeyInfo());
            return Pair.of(privateKey, publicKey);
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

    @Override
    public PrivateKey readPkcs8PrivateKey(Reader reader) {
        try (PEMParser pemParser = new PEMParser(reader)) {
            Object o = pemParser.readObject();
            return converter.getPrivateKey((PrivateKeyInfo) o);
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

}
