package io.bitexpress.openapi.client.sign;

import org.apache.commons.lang3.tuple.Pair;

import java.io.Reader;
import java.security.PrivateKey;
import java.security.PublicKey;

/**
 * 格式分类.
 * <p>pkcs1: -----BEGIN RSA PRIVATE KEY----- 包含了公密钥</p>
 * <p>pkcs8: -----BEGIN PRIVATE KEY----- 包含了密钥</p>
 */
public interface KeyReader {

    @Deprecated
    public Pair<PrivateKey, PublicKey> readKeyPair(Reader reader);

    @Deprecated
    public Pair<PrivateKey, PublicKey> readKeyPair(String pem);

    public PublicKey readPublicKey(Reader reader);

    public PublicKey readPublicKey(String pem);

    public Pair<PrivateKey, PublicKey> readPkcs1KeyPair(Reader reader);

    public Pair<PrivateKey, PublicKey> readPkcs1KeyPair(String pem);

    public PrivateKey readPkcs8PrivateKey(Reader reader);

    public PrivateKey readPkcs8PrivateKey(String pem);

}
