package io.bitexpress.openapi.client.sign;

import org.apache.commons.lang3.tuple.Pair;

import java.security.PrivateKey;
import java.security.PublicKey;

public interface KeyMaker {

    Pair<PrivateKey, PublicKey> makePair();

    /**
     * @return
     * @see Pair<String, String> makePemPkcs1Pair()
     * @deprecated use makePemPkcs1Pair instaed
     */
    @Deprecated
    Pair<String, String> makePemPair();

    /**
     * pkcs1的私钥包含了公钥
     *
     * @return
     */
    Pair<String, String> makePkcs1PemPair();

    /**
     * pkcs8的私钥不包含了公钥
     *
     * @return
     */
    Pair<String, String> makePkcs8PemPair();


    /**
     * @param pair
     * @return
     * @deprecated use exportPkcs1PemPair
     */
    @Deprecated
    Pair<String, String> exportPemPair(Pair<PrivateKey, PublicKey> pair);

    Pair<String, String> exportPkcs1PemPair(Pair<PrivateKey, PublicKey> pair);

    Pair<String, String> exportPkcs8PemPair(Pair<PrivateKey, PublicKey> pair);

    @Deprecated
    void makePemPair2File(String priavteKeyPemFile, String publicKeyPemFile);

    void makePkcs1PemPair2File(String priavteKeyPemFile, String publicKeyPemFile);

    void makePkcs8PemPair2File(String priavteKeyPemFile, String publicKeyPemFile);

}
