package io.bitexpress.openapi.client.sign;

import org.apache.commons.lang3.tuple.Pair;

import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.PublicKey;

public abstract class AbstractKeyReader implements KeyReader {
    public Pair<PrivateKey, PublicKey> readKeyPair(Reader reader) {
        return readPkcs1KeyPair(reader);
    }


    public Pair<PrivateKey, PublicKey> readKeyPair(String pem) {
        try (StringReader stringReader = new StringReader(pem)) {
            return readKeyPair(stringReader);
        }
    }


    public PublicKey readPublicKey(String pem) {
        try (StringReader stringReader = new StringReader(pem)) {
            return readPublicKey(stringReader);
        }
    }

    @Override
    public Pair<PrivateKey, PublicKey> readPkcs1KeyPair(String pem) {
        try (StringReader stringReader = new StringReader(pem)) {
            return readPkcs1KeyPair(stringReader);
        }
    }

    @Override
    public PrivateKey readPkcs8PrivateKey(String pem) {
        try (StringReader stringReader = new StringReader(pem)) {
            return readPkcs8PrivateKey(stringReader);
        }
    }

}
