package io.bitexpress.openapi.client.sign;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.tuple.Pair;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;

public abstract class AbstractKeyMaker implements KeyMaker {
    @Override
    public Pair<String, String> makePkcs1PemPair() {
        Pair<PrivateKey, PublicKey> pair = makePair();
        return exportPkcs1PemPair(pair);
    }

    @Override
    public Pair<String, String> makePkcs8PemPair() {
        Pair<PrivateKey, PublicKey> pair = makePair();
        return exportPkcs8PemPair(pair);
    }

    public Pair<String, String> exportPemPair(Pair<PrivateKey, PublicKey> pair) {
        return exportPkcs1PemPair(pair);
    }

    @Override
    public Pair<String, String> makePemPair() {
        return makePkcs1PemPair();
    }

    public void makePkcs1PemPair2File(String priavteKeyPemFile, String publicKeyPemFile) {
        Pair<String, String> makePemPair = makePkcs1PemPair();
        write2File(priavteKeyPemFile, publicKeyPemFile, makePemPair);
    }

    public void makePkcs8PemPair2File(String privateKeyPemFile, String publicKeyPemFile) {
        Pair<String, String> makePemPair = makePkcs8PemPair();
        write2File(privateKeyPemFile, publicKeyPemFile, makePemPair);
    }

    private void write2File(String privateKeyPemFile, String publicKeyPemFile, Pair<String, String> pemPair) {
        try {
            FileUtils.writeStringToFile(new File(privateKeyPemFile), pemPair.getLeft(), StandardCharsets.US_ASCII);
            FileUtils.writeStringToFile(new File(publicKeyPemFile), pemPair.getRight(), StandardCharsets.US_ASCII);
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public void makePemPair2File(String priavteKeyPemFile, String publicKeyPemFile) {
        makePkcs1PemPair2File(priavteKeyPemFile, publicKeyPemFile);
    }

    @Override
    public Pair<String, String> exportPkcs1PemPair(Pair<PrivateKey, PublicKey> pair) {
        String privateKeyPem = exportKey(pair.getLeft());
        String publicKeyPem = exportKey(pair.getRight());
        return Pair.of(privateKeyPem, publicKeyPem);
    }

    @Override
    public Pair<String, String> exportPkcs8PemPair(Pair<PrivateKey, PublicKey> pair) {
        String privateKeyPem = exportPkcs8Key(pair.getLeft());
        String publicKeyPem = exportKey(pair.getRight());
        return Pair.of(privateKeyPem, publicKeyPem);
    }

    public abstract String exportKey(Key key);

    public abstract String exportPkcs8Key(PrivateKey key);

}
