package io.bitexpress.openapi.client.notification;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.bitexpress.openapi.model.content.ServiceIndex;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.Function;


public class MapGatewayNotificationParserBuilder extends AbstractGatewayNotificationParserBuilder {


	protected Map<ServiceIndex, Class> notificationClassMap;

	@SuppressWarnings("rawtypes")
	protected Map<ServiceIndex, Class> notificationListClassMap;

	@SuppressWarnings("rawtypes")
	@Override
	protected Function<ServiceIndex, JavaType> getTypeFunction(ObjectMapper objectMapper) {
		Map<ServiceIndex, JavaType> map = new HashMap<>();
		TypeFactory typeFactory = objectMapper.getTypeFactory();

		if (notificationClassMap != null) {
			for (Entry<ServiceIndex, Class> entry : notificationClassMap.entrySet()) {
				map.put(entry.getKey(), typeFactory.constructType(entry.getValue()));
			}
		}
		if (notificationListClassMap != null) {
			for (Entry<ServiceIndex, Class> entry : notificationListClassMap.entrySet()) {
				map.put(entry.getKey(), typeFactory.constructCollectionType(List.class, entry.getValue()));
			}
		}
		return map::get;
	}

	@SuppressWarnings("rawtypes")
	public void setNotificationClassMap(Map<ServiceIndex, Class> notificationClassMap) {
		this.notificationClassMap = notificationClassMap;
	}

	@SuppressWarnings("rawtypes")
	public void setNotificationListClassMap(Map<ServiceIndex, Class> notificationListClassMap) {
		this.notificationListClassMap = notificationListClassMap;
	}

}
