package io.bitexpress.openapi.client.notification;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.openapi.client.BaseBuilder;
import io.bitexpress.openapi.model.content.ServiceIndex;
import lombok.Setter;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.security.PublicKey;
import java.util.function.Function;


public abstract class AbstractGatewayNotificationParserBuilder extends BaseBuilder {
    @Setter
    private Resource serverSidePublicKeyResource;

    public GatewayNotificationParser build() {
        ObjectMapper objectMapper = createObjectMapper();
        GatewayNotificationParserImpl gatewayNotificationParser = new GatewayNotificationParserImpl();
        gatewayNotificationParser.setObjectMapper(objectMapper);
        gatewayNotificationParser.setUid(uid);
        gatewayNotificationParser.setIssuerCode(issuerCode);
        gatewayNotificationParser.setIssuer(issuer);
        gatewayNotificationParser.setServerSidePublicKey(readPublicKey());
        Function<ServiceIndex, JavaType> notificationJavaTypeFunction = getTypeFunction(objectMapper);
        gatewayNotificationParser.setNotificationJavaTypeFunction(notificationJavaTypeFunction);
        return gatewayNotificationParser;
    }

    private PublicKey readPublicKey() {
        try (Reader reader = new InputStreamReader(serverSidePublicKeyResource.getInputStream())) {
            return keyReader.readPublicKey(reader);
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }


    public void setServerSidePublicKeyFilePath(Path serverSidePublicKeyFilePath) {
        setServerSidePublicKeyResource(new FileSystemResource(serverSidePublicKeyFilePath));
    }

    protected abstract Function<ServiceIndex, JavaType> getTypeFunction(ObjectMapper objectMapper);

}
