package io.bitexpress.openapi.client;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.openapi.model.content.OpenApiResponseContent;
import io.bitexpress.openapi.model.content.ServiceIndex;
import io.bitexpress.openapi.model.envelope.OpenApiEnvelope;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.math.BigDecimal;

public class GatewayClientImpl implements GatewayClient {
	public static final String DEFAULT_SUCCESS_RESPONSE_CODE = "SUCCESS";

	public static final BigDecimal DEFAULT_SIGNATURE_VERSION = new BigDecimal("1.0");

	private RestTemplate restTemplate;

	private String url;

	private ObjectMapper objectMapper;

	private String successResponseCode = DEFAULT_SUCCESS_RESPONSE_CODE;

	private RequestFactory requestFactory;

	@Override
	public <REQ, RES> RES invoke(ServiceIndex serviceIndex, REQ req, Class<RES> responseClass) {
		return invoke(serviceIndex, req, objectMapper.constructType(responseClass));
	}

	@Override
	public <REQ, RES> OpenApiResponseContent<RES> invokeSilently(ServiceIndex serviceIndex, REQ req,
																 Class<RES> responseClass) {
		return invokeSilently(serviceIndex, req, objectMapper.constructType(responseClass));
	}

	@Override
	public <REQ, RES> RES invoke(ServiceIndex serviceIndex, REQ req, JavaType responseJavaType) {
		OpenApiResponseContent<RES> invokeSilently = invokeSilently(serviceIndex, req, responseJavaType);
		if (!successResponseCode.equals(invokeSilently.getHeader().getResponseCode())) {
			throw new ErrorCodeException(invokeSilently.getHeader().getResponseCode(),
					invokeSilently.getHeader().getErrorMessage());
		}
		return invokeSilently.getBody();

	}

	@Override
	public <REQ, RES> OpenApiResponseContent<RES> invokeSilently(ServiceIndex serviceIndex, REQ req,
			JavaType responseBodyJavaType) {
		OpenApiEnvelope requestEnvelope = requestFactory.createRequestEnvelope(serviceIndex, req);
		JavaType responseContentType = objectMapper.getTypeFactory()
				.constructParametricType(OpenApiResponseContent.class, responseBodyJavaType);
		String resposneContentStr = restTemplate.postForObject(url, requestEnvelope, String.class);
		try {
			return objectMapper.readValue(resposneContentStr, responseContentType);
		} catch (IOException e) {
			throw new ContextedRuntimeException(e);
		}
	}

	public void setRestTemplate(RestTemplate restTemplate) {
		this.restTemplate = restTemplate;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public void setObjectMapper(ObjectMapper objectMapper) {
		this.objectMapper = objectMapper;
	}

	public ObjectMapper getObjectMapper() {
		return objectMapper;
	}

	public void setRequestFactory(RequestFactory requestFactory) {
		this.requestFactory = requestFactory;
	}

}
