package io.bitexpress.openapi.client;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.openapi.model.content.OpenApiResponseContent;
import io.bitexpress.openapi.model.content.ServiceIndex;


public interface GatewayClient {
	<REQ, RES> RES invoke(ServiceIndex serviceIndex, REQ req, Class<RES> responseClass);

	<REQ, RES> RES invoke(ServiceIndex serviceIndex, REQ req, JavaType responseJavaType);

	<REQ, RES> OpenApiResponseContent<RES> invokeSilently(ServiceIndex serviceIndex, REQ req, Class<RES> responseClass);

	<REQ, RES> OpenApiResponseContent<RES> invokeSilently(ServiceIndex serviceIndex, REQ req,
			JavaType responseJavaType);

	ObjectMapper getObjectMapper();

}
