/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.openapi.client.notification.GatewayNotificationParser;
import io.bitexpress.openapi.client.notification.MapGatewayNotificationParserBuilder;
import io.bitexpress.openapi.client.sign.bc.KeyReaderBcImpl;
import io.bitexpress.openapi.model.content.ServiceIndex;
import io.bitexpress.openapi.model.envelope.OpenApiEnvelope;
import java.math.BigDecimal;
import java.nio.file.Paths;
import java.util.HashMap;
import org.testng.annotations.Test;

public class MapGatewayNotificationParserBuilderTest {
    @Test
    public void testBuild() throws Exception {
        MapGatewayNotificationParserBuilder builder = new MapGatewayNotificationParserBuilder();
        builder.setUid(Long.valueOf(1L));
        builder.setServerSidePublicKeyFilePath(Paths.get("src/test/resources/test_public_key.pem", new String[0]));
        builder.setKeyReader(KeyReaderBcImpl.INSTANCE);
        HashMap<ServiceIndex, Class<Object>> map = new HashMap<ServiceIndex, Class<Object>>();
        ServiceIndex si = new ServiceIndex("payToAccount", new BigDecimal("1.0"));
        map.put(si, Object.class);
        builder.setNotificationClassMap(map);
        GatewayNotificationParser build = builder.build();
    }

    @Test(enabled=false)
    public void testBuild2() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        OpenApiEnvelope openApiEnvelope = new OpenApiEnvelope();
        openApiEnvelope.setUid(Long.valueOf(1L));
        openApiEnvelope.setSignature("6c8b28b05a12af3c0eaf2f3923d5b6330c7d493d8056ef21286d19bbcb72a6fbd4c925e8897d7e3a0720ee9784ed74ee40a9f19832ec3d044a606d8f595016a8a598959f664e2549bb1915777481bba54cd79572719c6eb935c2f2a2d529724779ef86df83fa11542915c9f2e81fb4c0fc3a3342d119f1e5552cc8a11b4857d53a93d0f8ecefd8988d273e043b5896e122bd17d3f794a0e392313f625db8c1b58357f89b08ade7c7184fa0dc33606af1d8facdd1d1b38458c805289612d68ebaf6851dc5517b6d6d1ef231075eb1ef997432bd9d9f63a1463a4f05ffc68e3ac4a4347794182dd232652430bc1187496887ddfe039a79a3175d92ef0f303b5d7a");
        openApiEnvelope.setSignatureVersion(new BigDecimal("1.0"));
        openApiEnvelope.setContent("{\"header\":{\"requestTime\":\"2019-07-10T16:32:13.521+0800\",\"service\":\"createFiatAcquireOrder\",\"serviceVersion\":1.0},\"body\":{\"amount\":5.780346,\"realArrivedAmount\":5.48392985,\"interactionMode\":\"CASHIER\",\"name\":\"20190710000001980-wangbin\",\"payeeUid\":\"490\",\"status\":\"SUCCESS\",\"assetCode\":\"USDT_ERC20\",\"createdTime\":\"2019-07-10T16:31:28.626+0800\",\"lastUpdatedTime\":\"2019-07-10T16:32:10.207+0800\",\"id\":\"20190710000046396\",\"outTradeNo\":\"1562747457138\",\"expiredTime\":\"2019-07-10T18:31:28.507+0800\",\"currency\":\"CNY\",\"fiatAmount\":40}}");
        MapGatewayNotificationParserBuilder builder = new MapGatewayNotificationParserBuilder();
        builder.setUid(Long.valueOf(1L));
        builder.setKeyReader(KeyReaderBcImpl.INSTANCE);
        builder.setServerSidePublicKeyFilePath(Paths.get("src/test/resources/test_public_key.pem", new String[0]));
        HashMap<ServiceIndex, Class<Object>> map = new HashMap<ServiceIndex, Class<Object>>();
        ServiceIndex si = new ServiceIndex("createFiatAcquireOrder", new BigDecimal("1.0"));
        map.put(si, Object.class);
        builder.setNotificationClassMap(map);
        GatewayNotificationParser build = builder.build();
        build.parseNotification(objectMapper.writeValueAsString((Object)openApiEnvelope));
    }
}

