/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.openapi.client;

import io.bitexpress.openapi.client.GatewayClient;
import io.bitexpress.openapi.client.GatewayClientBuilder;
import io.bitexpress.openapi.client.sign.bc.KeyReaderBcImpl;
import java.nio.file.Paths;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GatewayClientBuilderTest {
    @Test
    public void readFilePath() {
        GatewayClientBuilder builder = new GatewayClientBuilder();
        builder.setUid(Long.valueOf(1L));
        builder.setIssuerCode("1");
        builder.setUrl("aaa");
        builder.setKeyReader(KeyReaderBcImpl.INSTANCE);
        builder.setClientPrivateKeyFilePath(Paths.get("src/test/resources/test_private_key.pem", new String[0]));
        GatewayClient gatewayClient = builder.build();
        Assert.assertNotNull((Object)gatewayClient);
    }

    @Test
    public void readSpringContextResource() {
        GatewayClientBuilder builder = new GatewayClientBuilder();
        builder.setUid(Long.valueOf(1L));
        builder.setIssuerCode("1");
        builder.setUrl("aaa");
        builder.setKeyReader(KeyReaderBcImpl.INSTANCE);
        try (ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext();){
            Resource resource = applicationContext.getResource("classpath:/test_private_key.pem");
            builder.setClientPrivateKeyResource(resource);
        }
        GatewayClient gatewayClient = builder.build();
        Assert.assertNotNull((Object)gatewayClient);
    }
}

