package io.bitexpress.openapi.client.sign.sc;

import io.bitexpress.openapi.client.sign.KeyReader;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.tuple.Pair;
import org.spongycastle.asn1.x509.SubjectPublicKeyInfo;
import org.spongycastle.openssl.PEMKeyPair;
import org.spongycastle.openssl.PEMParser;
import org.spongycastle.openssl.jcajce.JcaPEMKeyConverter;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;

public class KeyReaderScImpl implements KeyReader {
    public static final KeyReader INSTANCE = new KeyReaderScImpl();
    private static JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("SC");

    static {
        Security.insertProviderAt(new org.spongycastle.jce.provider.BouncyCastleProvider(), 1);
    }

    private KeyReaderScImpl() {
    }

    public Pair<PrivateKey, PublicKey> readKeyPair(Reader reader) {
        try (PEMParser pemParser = new PEMParser(reader)) {
            PEMKeyPair kp = (PEMKeyPair) pemParser.readObject();
            PrivateKey privateKey = converter.getPrivateKey(kp.getPrivateKeyInfo());
            PublicKey publicKey = converter.getPublicKey(kp.getPublicKeyInfo());
            return Pair.of(privateKey, publicKey);
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

    public Pair<PrivateKey, PublicKey> readKeyPair(String pem) {
        try (StringReader stringReader = new StringReader(pem)) {
            return readKeyPair(stringReader);
        }
    }

    public PublicKey readPublicKey(Reader reader) {
        try (PEMParser pemParser = new PEMParser(reader)) {
            SubjectPublicKeyInfo ki = (SubjectPublicKeyInfo) pemParser.readObject();
            return converter.getPublicKey(ki);
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

    public PublicKey readPublicKey(String pem) {
        try (StringReader stringReader = new StringReader(pem)) {
            return readPublicKey(stringReader);
        }
    }

}
