package io.bitexpress.openapi.client.sign.sc;

import io.bitexpress.openapi.client.sign.KeyMaker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.tuple.Pair;
import org.spongycastle.openssl.jcajce.JcaPEMWriter;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.*;

public class KeyMakerScImpl implements KeyMaker {

    static {
        Security.insertProviderAt(new org.spongycastle.jce.provider.BouncyCastleProvider(), 1);
    }

    /**
     * @return Pair<PrivateKeyPemStr, PrivateKeyPemStr>
     */
    public void makePemPair2File(String priavteKeyPemFile, String publicKeyPemFile) {
        Pair<String, String> makePemPair = makePemPair();
        try {
            FileUtils.writeStringToFile(new File(priavteKeyPemFile), makePemPair.getLeft(), StandardCharsets.US_ASCII);
            FileUtils.writeStringToFile(new File(publicKeyPemFile), makePemPair.getRight(), StandardCharsets.US_ASCII);
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

    /**
     * @return Pair<PrivateKeyPairPemStr, PrivateKeyPemStr>
     */
    public Pair<String, String> makePemPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "SC");
            keyGen.initialize(2048);
            KeyPair keypair = keyGen.generateKeyPair();
            PrivateKey privateKey = keypair.getPrivate();
            PublicKey publicKey = keypair.getPublic();
            String privateKeyPem = exportKey(privateKey);
            String publicKeyPem = exportKey(publicKey);
            {
                try (StringWriter fos = new StringWriter()) {
                    try (JcaPEMWriter pem = new JcaPEMWriter(fos)) {
                        pem.writeObject(privateKey);
                        pem.flush();
                    }
                    fos.flush();
                    privateKeyPem = fos.toString();
                }
            }

            return Pair.of(privateKeyPem, publicKeyPem);
        } catch (NoSuchAlgorithmException | NoSuchProviderException | IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

    /**
     * @return Pair<PrivateKeyPairPemStr, PrivateKeyPemStr>
     */
    public String exportKey(Key key) {
        try {
            try (StringWriter fos = new StringWriter()) {
                try (JcaPEMWriter pem = new JcaPEMWriter(fos)) {
                    pem.writeObject(key);
                    pem.flush();
                }
                fos.flush();
                return fos.toString();
            }
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

}
