package io.bitexpress.openapi.client.sign.bc;

import io.bitexpress.openapi.client.sign.KeyReader;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.PublicKey;

public class KeyReaderBcImpl implements KeyReader {
    private static JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");

    static {
        java.security.Security.addProvider(new BouncyCastleProvider());
    }

    public static final KeyReader INSTANCE = new KeyReaderBcImpl();

    private KeyReaderBcImpl(){
    }

    public Pair<PrivateKey, PublicKey> readKeyPair(Reader reader) {
        try (PEMParser pemParser = new PEMParser(reader)) {
            PEMKeyPair kp = (PEMKeyPair) pemParser.readObject();
            PrivateKey privateKey = converter.getPrivateKey(kp.getPrivateKeyInfo());
            PublicKey publicKey = converter.getPublicKey(kp.getPublicKeyInfo());
            return Pair.of(privateKey, publicKey);
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

    public Pair<PrivateKey, PublicKey> readKeyPair(String pem) {
        try (StringReader stringReader = new StringReader(pem)) {
            return readKeyPair(stringReader);
        }
    }

    public PublicKey readPublicKey(Reader reader) {
        try (PEMParser pemParser = new PEMParser(reader)) {
            SubjectPublicKeyInfo ki = (SubjectPublicKeyInfo) pemParser.readObject();
            return converter.getPublicKey(ki);
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

    public PublicKey readPublicKey(String pem) {
        try (StringReader stringReader = new StringReader(pem)) {
            return readPublicKey(stringReader);
        }
    }

}
