package io.bitexpress.openapi.client.sign.bc;

import io.bitexpress.openapi.client.sign.KeyMaker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.*;

public class KeyMakerBcImpl implements KeyMaker {

    static {
        java.security.Security.addProvider(new BouncyCastleProvider());
    }

    public static final KeyMaker INSTANCE = new KeyMakerBcImpl();

    private KeyMakerBcImpl(){
    }
    /**
     * @return Pair<PrivateKeyPemStr, PrivateKeyPemStr>
     */
    @Override
	public void makePemPair2File(String priavteKeyPemFile, String publicKeyPemFile) {
        Pair<String, String> makePemPair = makePemPair();
        try {
            FileUtils.writeStringToFile(new File(priavteKeyPemFile), makePemPair.getLeft(), StandardCharsets.US_ASCII);
            FileUtils.writeStringToFile(new File(publicKeyPemFile), makePemPair.getRight(), StandardCharsets.US_ASCII);
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

    /**
     * @return Pair<PrivateKeyPairPemStr, PrivateKeyPemStr>
     */
    @Override
	public Pair<String, String> makePemPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
            keyGen.initialize(2048);
            KeyPair keypair = keyGen.generateKeyPair();
            PrivateKey privateKey = keypair.getPrivate();
            PublicKey publicKey = keypair.getPublic();
            String privateKeyPem = exportKey(privateKey);
            String publicKeyPem = exportKey(publicKey);
            {
                try (StringWriter fos = new StringWriter()) {
                    try (JcaPEMWriter pem = new JcaPEMWriter(fos)) {
                        pem.writeObject(privateKey);
                        pem.flush();
                    }
                    fos.flush();
                    privateKeyPem = fos.toString();
                }
            }

            return Pair.of(privateKeyPem, publicKeyPem);
        } catch (NoSuchAlgorithmException | NoSuchProviderException | IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

    /**
     * @return Pair<PrivateKeyPairPemStr, PrivateKeyPemStr>
     */
    @Override
	public String exportKey(Key key) {
        try {
            try (StringWriter fos = new StringWriter()) {
                try (JcaPEMWriter pem = new JcaPEMWriter(fos)) {
                    pem.writeObject(key);
                    pem.flush();
                }
                fos.flush();
                return fos.toString();
            }
        } catch (IOException e) {
            throw new ContextedRuntimeException(e);
        }
    }

}
