package io.bitexpress.openapi.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.bitexpress.openapi.client.sign.OaRsaSignatureTool;
import io.bitexpress.openapi.model.content.OpenApiRequestContent;
import io.bitexpress.openapi.model.content.OpenApiRequestHeader;
import io.bitexpress.openapi.model.content.ServiceIndex;
import io.bitexpress.openapi.model.envelope.OpenApiEnvelope;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

import java.math.BigDecimal;
import java.security.PrivateKey;
import java.util.Date;

public class RequestFactory extends FromHolder {
    public static final BigDecimal DEFAULT_SIGNATURE_VERSION = new BigDecimal("1.0");
    private BigDecimal signatureVersion = DEFAULT_SIGNATURE_VERSION;

    private ObjectMapper objectMapper;

    private PrivateKey privateKey;

    public <REQ> OpenApiEnvelope createRequestEnvelope(ServiceIndex serviceIndex, REQ req) {
        // assemble content
        OpenApiRequestContent<REQ> requestContent = new OpenApiRequestContent<>();
        requestContent.setBody(req);
        requestContent.setHeader(createHeader(serviceIndex));

        // marshall content
        String contentJson;
        try {
            contentJson = objectMapper.writeValueAsString(requestContent);
        } catch (JsonProcessingException e) {
            throw new ContextedRuntimeException(e);
        }

        // signature content
        String signHex = OaRsaSignatureTool.signUtf8ToHex(contentJson, privateKey);

        // assemble envelope
        OpenApiEnvelope envelope = new OpenApiEnvelope();
        envelope.setSignatureVersion(signatureVersion);
        envelope.setSignature(signHex);
        envelope.setContent(contentJson);
        envelope.setUid(uid);
        envelope.setIssuerCode(issuerCode);
        return envelope;
    }

    public OpenApiRequestHeader createHeader(ServiceIndex serviceIndex) {
        OpenApiRequestHeader apiRequestHeader = new OpenApiRequestHeader();
        apiRequestHeader.setPreserved(getPreserved());
        apiRequestHeader.setRequestTime(new Date());
        apiRequestHeader.setServiceIndex(serviceIndex);
        return apiRequestHeader;
    }

    public String getPreserved() {
        return null;
    }

    public void setSignatureVersion(BigDecimal signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }


}
