package io.bitexpress.openapi.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import io.bitexpress.openapi.client.sign.KeyReader;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

import java.util.TimeZone;

public class BaseBuilder extends FromHolder {

    protected KeyReader keyReader;

    public void setKeyReader(KeyReader keyReader) {
        this.keyReader = keyReader;
    }

    protected ObjectMapper createObjectMapper() {
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        StdDateFormat stdDateFormat = new StdDateFormat();
        stdDateFormat.setTimeZone(TimeZone.getDefault());
        builder.dateFormat(stdDateFormat);
        builder.featuresToEnable(SerializationFeature.WRITE_DATES_WITH_ZONE_ID);
        builder.featuresToDisable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        builder.featuresToEnable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN);
        builder.serializationInclusion(JsonInclude.Include.NON_NULL);
        return builder.build();
    }
}
