/*
 * Decompiled with CFR 0.152.
 */
package io.bigconnect.web.actions.google;

import com.google.inject.Singleton;
import com.mware.core.model.Description;
import com.mware.core.model.Name;
import com.mware.web.BcCsrfHandler;
import com.mware.web.WebApp;
import com.mware.web.WebAppPlugin;
import com.mware.web.framework.Handler;
import com.mware.web.privilegeFilters.EditPrivilegeFilter;
import io.bigconnect.web.actions.google.routes.GoogleSpeech2Text;
import io.bigconnect.web.actions.google.routes.GoogleTranslate;
import javax.servlet.ServletContext;

@Name(value="Google Cloud UI Actions")
@Description(value="UI actions for Google Speech2Text and Google Translate")
@Singleton
public class GoogleActionsWebAppPlugin
implements WebAppPlugin {
    public void init(WebApp app, ServletContext servletContext, Handler authenticationHandler) {
        app.post("/google/translate", new Class[]{authenticationHandler.getClass(), BcCsrfHandler.class, EditPrivilegeFilter.class, GoogleTranslate.class});
        app.post("/google/s2t", new Class[]{authenticationHandler.getClass(), BcCsrfHandler.class, EditPrivilegeFilter.class, GoogleSpeech2Text.class});
        app.registerJavaScript("/io/bigconnect/web/actions/google/plugin.js");
        app.registerResourceBundle("/io/bigconnect/web/actions/google/messages.properties");
        app.registerWebWorkerJavaScript("/io/bigconnect/web/actions/google/service.js");
    }
}

