/*
 * Decompiled with CFR 0.152.
 */
package com.mware.web.auth.usernamepassword.routes;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.inject.Inject;
import com.mware.core.config.Configuration;
import com.mware.core.email.EmailRepository;
import com.mware.core.exception.BcException;
import com.mware.core.model.user.UserRepository;
import com.mware.core.user.User;
import com.mware.core.util.BcLogger;
import com.mware.core.util.BcLoggerFactory;
import com.mware.web.BadRequestException;
import com.mware.web.BcResponse;
import com.mware.web.auth.usernamepassword.ForgotPasswordConfiguration;
import com.mware.web.framework.ParameterizedHandler;
import com.mware.web.framework.annotations.Handle;
import com.mware.web.framework.annotations.Optional;
import com.mware.web.model.ClientApiSuccess;
import com.mware.web.parameterProviders.BaseUrl;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class RequestToken
implements ParameterizedHandler {
    private static final BcLogger LOGGER = BcLoggerFactory.getLogger(RequestToken.class);
    private static final String USERNAME_PARAMETER_NAME = "username";
    private static final String TEMPLATE_PATH = "/com/mware/web/auth/usernamepassword/templates";
    private static final String TEMPLATE_NAME = "forgotPasswordEmail";
    private static final String CHARSET = "UTF-8";
    private final UserRepository userRepository;
    private ForgotPasswordConfiguration forgotPasswordConfiguration;
    private final EmailRepository emailRepository;

    @Inject
    public RequestToken(UserRepository userRepository, Configuration configuration, EmailRepository emailRepository) {
        this.userRepository = userRepository;
        this.emailRepository = emailRepository;
        this.forgotPasswordConfiguration = new ForgotPasswordConfiguration();
        configuration.setConfigurables((Object)this.forgotPasswordConfiguration, "forgotPassword");
    }

    @Handle
    public ClientApiSuccess handle(@BaseUrl String baseUrl, @Optional(name="username") String username) throws Exception {
        if (username == null) {
            throw new BadRequestException(USERNAME_PARAMETER_NAME, "username required");
        }
        User user = this.userRepository.findByUsername(username);
        if (user == null) {
            throw new BadRequestException(USERNAME_PARAMETER_NAME, "username not found");
        }
        if (user.getEmailAddress() == null) {
            throw new BadRequestException(USERNAME_PARAMETER_NAME, "no e-mail address available for user");
        }
        this.createTokenAndSendEmail(baseUrl, user);
        return BcResponse.SUCCESS;
    }

    private void createTokenAndSendEmail(String baseUrl, User user) throws IOException {
        String token = this.createToken(user);
        String displayNameOrUsername = user.getDisplayName() != null ? user.getDisplayName() : user.getUsername();
        String url = baseUrl + "/forgotPassword" + "?" + "token" + "=" + token;
        String body = this.getEmailBody(displayNameOrUsername, url);
        this.sendEmail(user.getEmailAddress(), body);
        LOGGER.info("sent password reset e-mail to: %s", new Object[]{user.getEmailAddress()});
    }

    private String createToken(User user) {
        String token = new BigInteger(240, new SecureRandom()).toString(32);
        ZonedDateTime cal = ZonedDateTime.now();
        cal.plusMinutes(this.forgotPasswordConfiguration.getTokenLifetimeMinutes());
        this.userRepository.setPasswordResetTokenAndExpirationDate(user, token, cal);
        return token;
    }

    private String getEmailBody(String displayNameOrUsername, String url) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("displayNameOrUsername", displayNameOrUsername);
        context.put("url", url);
        ClassPathTemplateLoader templateLoader = new ClassPathTemplateLoader(TEMPLATE_PATH);
        Handlebars handlebars = new Handlebars((TemplateLoader)templateLoader);
        Template template = handlebars.compile(TEMPLATE_NAME);
        return template.apply(context);
    }

    private void sendEmail(String to, String body) {
        try {
            MimeMessage mimeMessage = new MimeMessage(this.emailRepository.getSession());
            mimeMessage.setFrom((Address)InternetAddress.parse((String)this.forgotPasswordConfiguration.getEmailFrom())[0]);
            mimeMessage.setReplyTo((Address[])InternetAddress.parse((String)this.forgotPasswordConfiguration.getEmailReplyTo()));
            mimeMessage.setSubject(this.forgotPasswordConfiguration.getEmailSubject(), CHARSET);
            mimeMessage.setText(body, CHARSET);
            mimeMessage.setSentDate(new Date());
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            Transport.send((Message)mimeMessage);
        }
        catch (MessagingException e) {
            throw new BcException("exception while sending e-mail", (Throwable)e);
        }
    }
}

