/*
 * Decompiled with CFR 0.152.
 */
package com.mware.web.auth.usernamepassword.routes;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.inject.Inject;
import com.mware.core.config.Configuration;
import com.mware.core.exception.BcAccessDeniedException;
import com.mware.core.model.user.UserRepository;
import com.mware.core.user.User;
import com.mware.web.auth.usernamepassword.ForgotPasswordConfiguration;
import com.mware.web.framework.ParameterizedHandler;
import com.mware.web.framework.annotations.ContentType;
import com.mware.web.framework.annotations.Handle;
import com.mware.web.framework.annotations.Required;
import com.mware.web.parameterProviders.BaseUrl;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.HashMap;

public class LookupToken
implements ParameterizedHandler {
    public static final String TOKEN_PARAMETER_NAME = "token";
    private static final String TEMPLATE_PATH = "/com/mware/web/auth/usernamepassword/templates";
    private static final String TEMPLATE_NAME = "changePasswordWithToken";
    private final UserRepository userRepository;
    private ForgotPasswordConfiguration forgotPasswordConfiguration;

    @Inject
    public LookupToken(UserRepository userRepository, Configuration configuration) {
        this.userRepository = userRepository;
        this.forgotPasswordConfiguration = new ForgotPasswordConfiguration();
        configuration.setConfigurables((Object)this.forgotPasswordConfiguration, "forgotPassword");
    }

    @Handle
    @ContentType(value="text/html")
    public String handle(@BaseUrl String baseUrl, @Required(name="token") String token) throws Exception {
        User user = this.userRepository.findByPasswordResetToken(token);
        if (user == null) {
            throw new BcAccessDeniedException("invalid token", null, null);
        }
        if (!user.getPasswordResetTokenExpirationDate().isAfter(ZonedDateTime.now())) {
            throw new BcAccessDeniedException("expired token", user, null);
        }
        return this.getHtml(baseUrl, token);
    }

    private String getHtml(String baseUrl, String token) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("formAction", baseUrl + "/forgotPassword/changePassword");
        context.put("tokenParameterName", TOKEN_PARAMETER_NAME);
        context.put(TOKEN_PARAMETER_NAME, token);
        context.put("newPasswordLabel", this.forgotPasswordConfiguration.getNewPasswordLabel());
        context.put("newPasswordParameterName", "newPassword");
        context.put("newPasswordConfirmationLabel", this.forgotPasswordConfiguration.getNewPasswordConfirmationLabel());
        context.put("newPasswordConfirmationParameterName", "newPasswordConfirmation");
        ClassPathTemplateLoader templateLoader = new ClassPathTemplateLoader(TEMPLATE_PATH);
        Handlebars handlebars = new Handlebars((TemplateLoader)templateLoader);
        Template template = handlebars.compile(TEMPLATE_NAME);
        return template.apply(context);
    }
}

